function ContentGalleryCtrl($scope, $rootScope){
    $scope.Activity = null;
    $scope.currentContent = null;
    $scope.contents = [];


    $scope.$on('Activity:select', function(broadcast, Activity){
        $scope.Activity = Activity;
        if(Activity.getType() == '_zoom' || Activity.getType() == '_gallery')
        {
            $scope.contents = Activity.getContents();
            $scope.currentContent = $scope.contents[0];
        }
    });

    $scope.isFirst = function(){
        return $scope.currentContent == $scope.contents[0];
    }

    $scope.isLast = function(){
        return $scope.currentContent == $scope.contents[($scope.contents.length - 1)];
    }

    $scope.goNextImg = function(){
        if(!$scope.isLast())
        {
            var index = $scope.contents.indexOf($scope.currentContent)
            $scope.currentContent = $scope.contents[++index];
        }
    }
    $scope.goPrevImg = function(){
        if(!$scope.isFirst())
        {
            var index = $scope.contents.indexOf($scope.currentContent)
            $scope.currentContent = $scope.contents[--index];
        }
    }

    $scope.closeModal = function(){
        angular.element('#modal-gallery').modal('hide');
    }
}

ContentGalleryCtrl.$inject = ['$scope', '$rootScope'];